/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml.core.index;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.xml.core.index.IKeyProvider;
import com.aptana.xml.core.model.AttributeElement;
import com.aptana.xml.core.model.ElementElement;
import com.aptana.xml.core.model.ValueElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLIndexReader {
    private IKeyProvider _keyProvider;

    public XMLIndexReader(IKeyProvider keyProvider) {
        this._keyProvider = keyProvider;
    }

    private ElementElement createElementFromKey(Index index, String key) {
        String[] columns = key.split("\u0000");
        ElementElement element = new ElementElement();
        int column = 0;
        element.setName(columns[column++]);
        element.setDisplayName(columns[column++]);
        String[] stringArray = columns[column++].split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            element.addAttribute(attribute);
            ++n2;
        }
        if (column < columns.length) {
            element.setDescription(columns[column++]);
        }
        return element;
    }

    public ElementElement getElement(Index index, String name) {
        Iterator iterator;
        String searchKey = String.valueOf(name) + "\u0000";
        List items = index.query(new String[]{this._keyProvider.getElementKey()}, searchKey, 1);
        ElementElement result = null;
        if (items != null && (iterator = items.iterator()).hasNext()) {
            QueryResult item = (QueryResult)iterator.next();
            String key = item.getWord();
            result = this.createElementFromKey(index, key);
        }
        return result;
    }

    public List<ElementElement> getElements(Index index) {
        List items = index.query(new String[]{this._keyProvider.getElementKey()}, "*", 2);
        LinkedList<ElementElement> result = new LinkedList<ElementElement>();
        if (items != null) {
            for (QueryResult item : items) {
                String key = item.getWord();
                ElementElement element = this.createElementFromKey(index, key);
                result.add(element);
            }
        }
        return result;
    }

    public AttributeElement getAttribute(Index index, String elementName, String attributeName) {
        Iterator iterator;
        String searchKey = StringUtil.join((String)"\u0000", (String[])new String[]{attributeName, elementName, "*"});
        List items = index.query(new String[]{this._keyProvider.getAttributeKey()}, searchKey, 2);
        if (!CollectionsUtil.isEmpty((Collection)items) && (iterator = items.iterator()).hasNext()) {
            QueryResult item = (QueryResult)iterator.next();
            String key = item.getWord();
            return this.createAttributeFromKey(key);
        }
        return null;
    }

    private AttributeElement createAttributeFromKey(String key) {
        String[] columns = key.split("\u0000");
        AttributeElement attribute = new AttributeElement();
        int column = 0;
        attribute.setName(columns[column++]);
        attribute.setElement(columns[column++]);
        attribute.setDescription(columns[column++]);
        if (column < columns.length) {
            String[] stringArray = columns[column++].split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String valueName = stringArray[n2];
                ValueElement value = new ValueElement();
                value.setName(valueName);
                attribute.addValue(value);
                ++n2;
            }
        }
        return attribute;
    }
}

